#ifndef AUBO_SCOPE_DIRECTION_NODE_H
#define AUBO_SCOPE_DIRECTION_NODE_H

#include <aubo_caps/domain/program/nodes/program_node.h>
#include <aubo_caps/domain/value/expression/expression.h>
#include <aubo_caps/domain/feature/feature.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(DirectionNode);

class ARCS_ABI_EXPORT DirectionNode : public ProgramNode
{
public:
    enum ParameterType : int
    {
        /**
         * The tool motion parameters are inherited from the MoveL or
         MoveP
         * parent.
         */
        SHARED_MOTION,

        /**
         * The tool motion parameters are selected. <br>
         *
         * The Selection instance can be cast to {@link
         ToolMotionParameters}.
         */
        TOOL_MOTION
    };

    enum Axis : int
    {
        /**
         * Move in the positive X direction relative to the feature.
         */
        X_PLUS,

        /**
         * Move in the negative X direction relative to the feature.
         */
        X_MINUS,

        /**
         * Move in the positive Y direction relative to the feature.
         */
        Y_PLUS,

        /**
         * Move in the negative Y direction relative to the feature.
         */
        Y_MINUS,

        /**
         * Move in the positive Z direction relative to the feature.
         */
        Z_PLUS,

        /**
         * Move in the negative Z direction relative to the feature.
         */
        Z_MINUS
    };

    enum DirectionSelectionType : int
    {
        /**
         * A direction vector is specified using an Expression.
         * The Selection instance can be cast to {@link
         * DirectionVectorExpression}
         */
        EXPRESSION,

        /**
         * Direction is specified using an Axis.
         * The Selection instance can be cast to {@link DirectionAxis}
         */
        AXIS
    };

    enum FeatureSelectionType : int
    {
        /**
         * The selected feature is no longer available (e.g. because the user
         * has removed the feature in the Installation or the needed
         * Installation is not currently loaded)
         */
        UNRESOLVED_FEATURE,

        /**
         * Feature is inherited from the MoveL or MoveP parent.
         */
        SHARED,

        /**
         * Feature is selected. <br>
         * The Selection instance can be cast to {@link DirectionNodeFeature}
         */
        FEATURE
    };

    DirectionNode(DirectionNode &f);
    DirectionNode(DirectionNode &&f);
    virtual ~DirectionNode();

    ParameterType getType();
    void setType(ParameterType type);

    /**
     * @return the Axis used to define the direction.
     */
    Axis getAxis();
    void setAxis(Axis axis);

    /**
     *
     * @return the feature selected for this Direction node.
     */
    FeaturePtr getFeature();
    void setFeature(FeaturePtr feature);

    DirectionSelectionType getDirectionSelectionType();
    void setDirectionSelectionType(DirectionSelectionType selection);
    /**
     *
     * @return the expression used to define the direction vector.
     */
    ExpressionPtr getExpression();
    void setExpression(ExpressionPtr expression);

    FeatureSelectionType getFeatureSelectionType();
    void setFeatureSelectionType(FeatureSelectionType selection);
    /**
     * @return the tool speed to be achieved.
     */
    double getToolSpeed();
    void setToolSpeed(double speed);

    /**
     * @return the tool acceleration to use for the movement
     */
    double getToolAcceleration();
    void setToolAcceleration(double acc);

private:
    friend class DataSwitch;
    DirectionNode();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs
#endif // AUBO_SCOPE_DIRECTION_NODE_H
