#ifndef AUBO_SCOPE_ELSE_IF_NODE_H
#define AUBO_SCOPE_ELSE_IF_NODE_H

#include <aubo_caps/domain/program/nodes/program_node.h>
#include <aubo_caps/domain/value/expression/expression.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(ElseIfNode);

class ARCS_ABI_EXPORT ElseIfNode : public ProgramNode
{
public:
    ElseIfNode(ElseIfNode &f);
    ElseIfNode(ElseIfNode &&f);
    virtual ~ElseIfNode();

    /**
     * @param expression The expression that will be evaluated in this
     * ElseIfNode.
     * @return The same ElseIfNode.
     */
    void setExpression(ExpressionPtr expression);

    /**
     * @return the Expression to be evaluated in this ElseIf node.
     */
    ExpressionPtr getExpression();

private:
    friend class DataSwitch;
    ElseIfNode();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs
#endif // AUBO_SCOPE_ELSE_IF_NODE_H
