#ifndef AUBO_SCOPE_FOLDER_NODE_H
#define AUBO_SCOPE_FOLDER_NODE_H

#include <aubo_caps/domain/program/nodes/program_node.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(FolderNode);

class ARCS_ABI_EXPORT FolderNode : public ProgramNode
{
public:
    FolderNode(FolderNode &f);
    FolderNode(FolderNode &&f);
    virtual ~FolderNode();

    /**
     * * Set the name for the Folder node.
     * @param set The name for the node.
     * @return This node.
     */
    void setFolderName(const std::string &folder_name);

private:
    friend class DataSwitch;
    FolderNode();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs
#endif // AUBO_SCOPE_FOLDER_NODE_H
