#ifndef AUBO_SCOPE_FORCE_NODE_H
#define AUBO_SCOPE_FORCE_NODE_H

#include <vector>
#include <aubo_caps/domain/program/nodes/program_node.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(ForceNode);

class ARCS_ABI_EXPORT ForceNode : public ProgramNode
{
public:
    /**
     * The configuration type used to determine which type of configuration this
     * instance is.
     */
    enum ConfigType
    {

        /**
         * <p>
         * Simple type is selected. This type has no further information.
         * </p>
         *
         * Setting this type of config will be ignored and will have no effect
         * on the node.
         */
        SIMPLE,

        /**
         * <p>
         * Frame type is selected.
         * </p>
         *
         * The config instance can be cast to {@link FrameForceNodeConfig}.
         */
        FRAME,

        /**
         * <p>
         * Point type is selected. This type has no further information.
         * </p>
         *
         * Setting this type of config will be ignored and will have no effect
         * on the node.
         */
        POINT,

        /**
         * <p>
         * Motion type is selected. This type has no further information.
         * </p>
         *
         * Setting this type of config will be ignored and will have no effect
         * on the node.
         */
        MOTION
    };

    ForceNode(ForceNode &f);
    ForceNode(ForceNode &&f);
    virtual ~ForceNode();

private:
    friend class DataSwitch;
    ForceNode();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs
#endif // AUBO_SCOPE_FORCE_NODE_H
