#ifndef AUBO_SCOPE_IF_NODE_H
#define AUBO_SCOPE_IF_NODE_H

#include <aubo_caps/domain/program/nodes/program_node.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(Expression);
ARCS_CLASS_FORWARD(IfNode);

class ARCS_ABI_EXPORT IfNode : public ProgramNode
{
public:
    IfNode(IfNode &f);
    IfNode(IfNode &&f);
    virtual ~IfNode();

    /**
     * Sets the expression used by the node.
     *
     * @param expression The expression that will be evaluated in this If Node.
     * @return The same If Node.
     * @throws IllegalStateException if called from a Swing-based AuboCap
     * outside of an {@link UndoableChanges} scope (see also {@link
     * UndoRedoManager}).
     */
    void setExpression(ExpressionPtr expression);

    /**
     * @return the Expression to be evaluated in this If node.
     */
    ExpressionPtr getExpression();

private:
    friend class DataSwitch;
    IfNode();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs
#endif // AUBO_SCOPE_IF_NODE_H
