#ifndef AUBO_SCOPE_POPUP_NODE_H
#define AUBO_SCOPE_POPUP_NODE_H

#include <string>
#include <aubo_caps/domain/program/nodes/program_node.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(PopupNode);

class ARCS_ABI_EXPORT PopupNode : public ProgramNode
{
public:
    enum Type
    {
        MESSAGE,
        WARNING,
        ERROR
    };

    PopupNode(PopupNode &f);
    PopupNode(PopupNode &&f);
    virtual ~PopupNode();

    /**
     *
     * @param message the message in the pop up for the end user
     * @return this node
     * @throws IllegalStateException if called from a Swing-based AuboCap
     * outside of an {@link UndoableChanges} scope (see also {@link
     * UndoRedoManager})
     */

    void setMessage(std::string message);
    std::string getMessage();
    /**
     *
     * @param type the type of pop up
     * @return this node
     * @throws IllegalStateException if called from a Swing-based AuboCap
     * outside of an {@link UndoableChanges} scope (see also {@link
     * UndoRedoManager})
     */
    void setType(Type type);
    Type getType() const;

private:
    friend class DataSwitch;
    PopupNode();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs
#endif // AUBO_SCOPE_POPUP_NODE_H
