#ifndef AUBO_SCOPE_SET_PAYLOAD_NODE_H
#define AUBO_SCOPE_SET_PAYLOAD_NODE_H

#include <vector>
#include <aubo_caps/domain/program/nodes/program_node.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(SetPayloadNode);

class ARCS_ABI_EXPORT SetPayloadNode : public ProgramNode
{
public:
    /**
     * This base interface represents a configuration of the Set Payload program
     * node (i.e. a {@link SetPayloadNode}
     * instance).
     */
    enum ConfigType
    {
        /**
         * <p>
         * A payload (from the installation) is selected.
         * </p>
         *
         * The config instance can be cast to {@link
         * SelectionPayloadNodeConfig}.
         */
        PAYLOAD_SELECTION,

        /**
         * <p>
         * Custom payload parameters are specified.
         * </p>
         *
         * The config instance can be cast to {@link
         * CustomParametersPayloadNodeConfig}.
         */
        CUSTOM_PARAMETERS
    };

    SetPayloadNode(SetPayloadNode &f);
    SetPayloadNode(SetPayloadNode &&f);
    virtual ~SetPayloadNode();

    /**
     * This method returns the type of configuration. Cast this instance
     * appropriately to have access to specific getters.
     *
     * @return The type of this config.
     */
    ConfigType getConfigType();
    void setConfigType(ConfigType type);

    /**
     * @return The total mass of the payload
     */
    double getMass();
    void setMass(double mass);

    /**
     * Gets the payload's center of gravity (CoG), also referred to as center of
     * mass. It is defined as the offset between the center of the tool output
     * flange and the center of gravity of the attached payload.
     *
     * @return The center of gravity (CoG) of the payload relative to the center
     * of the tool output flange
     */
    std::vector<double> getCenterOfGravity();
    void setCenterOfGravity(const std::vector<double> &cog);

private:
    friend class DataSwitch;
    SetPayloadNode();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs
#endif // AUBO_SCOPE_SET_PAYLOAD_NODE_H
