#ifndef AUBO_SCOPE_PROGRAM_NODE_H
#define AUBO_SCOPE_PROGRAM_NODE_H

#include <aubo_caps/class_forward.h>
#include <aubo_caps/contribution/program/program_node_contribution.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(ProgramNode);

/**
 * <p>
 * This interface represents AuboScope program nodes.
 * </p>
 *
 * The program nodes can be created using {@link ProgramNodeFactory}.
 */
class ARCS_ABI_EXPORT ProgramNode
{
public:
    ProgramNode(ProgramNode &f);
    ProgramNode(ProgramNode &&f);
    virtual ~ProgramNode();

    /// 不推荐用户调用 ProgramNodeContribution::generateScript
    /// 使用 ScriptWritter::writeChildren
    [[deprecated]] ProgramNodeContributionPtr getProgramNodeContribution();

protected:
    ProgramNode();

private:
    friend class DataSwitch;
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_PROGRAM_NODE_H
