#ifndef AUBO_SCOPE_PROGRAM_API_H
#define AUBO_SCOPE_PROGRAM_API_H

#include <aubo_caps/domain/application_api.h>
#include <aubo_caps/domain/program/program_model.h>
#include <aubo_caps/domain/undoredo/undo_redo_manager.h>
#include <aubo_caps/domain/waypoint/waypoint_model.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(ProgramApi);

/**
 * Provides access to functionality and services related to programs. This
 * includes what is available from within AuboScope, as well as creating
 * additional model elements to be used within AuboScope.
 */
class ARCS_ABI_EXPORT ProgramApi : public ApplicationApi
{
public:
    ProgramApi(ProgramApi &f);
    ProgramApi(ProgramApi &&f);
    virtual ~ProgramApi();

    /**
     * @return An interface for working with the sub-trees of a program node
     */
    ProgramModelPtr getProgramModel();

    /**
     * @return  An interface for working with waypoints
     */
    WaypointModelPtr getWaypointModel();

    /**
     * @return An interface for recording undoable changes for program node
     * contributions
     */
    UndoRedoManagerPtr getUndoRedoManager();

private:
    friend class DataSwitch;
    ProgramApi();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs
#endif // AUBO_SCOPE_PROGRAM_API_H
