#ifndef AUBO_SCOPE_TCP_H
#define AUBO_SCOPE_TCP_H

#include <string>
#include <vector>
#include <aubo_caps/class_forward.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(TCP);

/**
 * This interface represents a TCP in AuboScope. This can either be a
 * user-defined TCP or a TCP added by a AuboCap.
 */
class ARCS_ABI_EXPORT TCP
{
public:
    TCP(TCP &f);
    TCP(TCP &&f);
    ~TCP();

    /**
     * @return The offset of the TCP with respect to the tool output flange, if
     * the TCP is resolvable, otherwise null.
     */
    std::vector<double> getOffset();

    /**
     * Note: The TCP can be renamed at any time
     *
     * @return The name of the TCP
     */
    std::string getDisplayName();

    /**
     * A TCP cannot be guaranteed to be present in AuboScope. The end user can
     * load a different installation (not containing the TCP) or the TCP was
     * removed by the end user or the AuboCap that added the tcp/ This method
     * can be used to determine, if the TCP is present.
     *
     * @return <code>true</code> if this TCP is present in AuboScope, otherwise
     * <code>false</code>.
     */
    bool isResolvable();

    size_t hashCode();

private:
    friend class DataSwitch;
    TCP();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_TCP_H
