#ifndef AUBO_SCOP_TCP_MODEL_H
#define AUBO_SCOP_TCP_MODEL_H

#include <vector>
#include <functional>
#include <aubo_caps/domain/tcp/tcp.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(TcpModel);

/**
 * This interface provides access to the TCPs that are currently available in
 * AuboScope.
 */
class ARCS_ABI_EXPORT TcpModel
{
public:
    TcpModel(TcpModel &f);
    TcpModel(TcpModel &&f);
    virtual ~TcpModel();

    /**
     * @return A collection of all the TCPs in AuboScope, including user-defined
     * TCPs and TCPs added by aubo_studio plugins.
     */
    std::vector<TCPPtr> getAll();
    TCPPtr getTcp(const std::string &name);

    TCPPtr getDefaultTcp();

    std::string connectedTo(const std::string &receiver,
                            const std::function<void(TcpModel *)> &slot);

    void disconnectFrom(const std::string &receiver);

private:
    friend class DataSwitch;
    TcpModel();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOP_TCP_MODEL_H
