#ifndef AUBO_SCOPE_UNDO_REDO_MANAGER_H
#define AUBO_SCOPE_UNDO_REDO_MANAGER_H

#include <functional>
#include <aubo_caps/class_forward.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(UndoRedoManager);

/**
 * <p>
 * This interface is used to record changes triggered by an end user in the
 * screen of a AuboCap program node contribution (e.g. when a button is
 * clicked). It should be used in a AuboCap program node to support the
 * Undo/Redo functionality in AuboScope.
 * </p>
 *
 * <p>
 * NOTE: Do not use this functionality for AuboCap installation nodes, since it
 * is not supported (and has no effect). <br>
 *
 * NOTE: This functionality is not relevant for AuboCap program nodes with a
 * HTML-based user interface, since automatic undo is supported for these.
 * </p>
 */
class ARCS_ABI_EXPORT UndoRedoManager
{
public:
    UndoRedoManager(UndoRedoManager &f);
    UndoRedoManager(UndoRedoManager &&f);
    virtual ~UndoRedoManager();

    /**
     * <p>
     * Group changes into one Undo/Redo step.
     * </p>
     *
     * Currently Undo/Redo supports changes to the program tree and the data
     * model.
     *
     * @param undoableChanges Code to be recorded as one Undo/Redo step.
     * Pressing Undo in AuboScope will undo all changes
     * done to the program tree and the data model inside this block of code.
     */
    void recordChanges(const std::string &text,
                       std::function<void()> undoableChanges);

private:
    friend class DataSwitch;
    UndoRedoManager();
    void *d_{ nullptr };
};
} // namespace aubo_scope
} // namespace arcs

#endif
