#ifndef AUBO_CAPS_INTERFACE_KEYBOARD_MANAGER_H
#define AUBO_CAPS_INTERFACE_KEYBOARD_MANAGER_H

#include <string>
#include <functional>

#include <aubo_caps/class_forward.h>
#include <aubo_caps/domain/user_interface/input_validator.h>

class QWidget;

namespace arcs {
namespace aubo_scope {

ARCS_CLASS_FORWARD(KeyboardManager);
ARCS_CLASS_FORWARD(Expression);

class ARCS_ABI_EXPORT KeyboardManager
{
public:
    KeyboardManager(KeyboardManager &f);
    KeyboardManager(KeyboardManager &&f);
    virtual ~KeyboardManager();

    void registerStandardKeyboard(
        QWidget *wd, std::function<std::string(void)> init_cb = nullptr,
        const std::shared_ptr<InputValidator> &validator = nullptr,
        std::function<void(std::string)> result_cb = nullptr);
    void registerStringKeyboard(
        QWidget *wd, std::function<std::string(void)> init_cb = nullptr,
        const std::shared_ptr<InputValidator> &validator = nullptr,
        std::function<void(std::string)> result_cb = nullptr);
    void registerPasswordKeyboard(
        QWidget *wd, std::function<std::string(void)> init_cb = nullptr,
        const std::shared_ptr<InputValidator> &validator = nullptr,
        std::function<void(std::string)> result_cb = nullptr);
    void registerCodeEditerKeyboard(
        QWidget *wd, std::function<std::string(void)> init_cb = nullptr,
        const std::shared_ptr<InputValidator> &validator = nullptr,
        std::function<void(std::string)> result_cb = nullptr);
    void registerNumberKeyboard(
        QWidget *wd, std::function<std::string(void)> init_cb = nullptr,
        const std::shared_ptr<InputValidator> &validator = nullptr,
        std::function<void(std::string)> result_cb = nullptr);
    void registerDoubleKeyboard(
        QWidget *wd, std::function<std::string(void)> init_cb = nullptr,
        const std::shared_ptr<InputValidator> &validator = nullptr,
        std::function<void(std::string)> result_cb = nullptr);
    void registerPositiveDoubleKeyboard(
        QWidget *wd, std::function<std::string(void)> init_cb = nullptr,
        const std::shared_ptr<InputValidator> &validator = nullptr,
        std::function<void(std::string)> result_cb = nullptr);
    void registerIntegerKeyboard(
        QWidget *wd, std::function<std::string(void)> init_cb = nullptr,
        const std::shared_ptr<InputValidator> &validator = nullptr,
        std::function<void(std::string)> result_cb = nullptr);
    void registerPositiveIntegerKeyboard(
        QWidget *wd, std::function<std::string(void)> init_cb = nullptr,
        const std::shared_ptr<InputValidator> &validator = nullptr,
        std::function<void(std::string)> result_cb = nullptr);
    void registerIPAddressKeyboard(
        QWidget *wd, std::function<std::string(void)> init_cb = nullptr,
        std::function<void(std::string)> result_cb = nullptr);
    void registerExpressionKeyboard(
        QWidget *wd, std::function<ExpressionPtr(void)> init_cb = nullptr,
        std::function<void(ExpressionPtr result_value)> result_cb = nullptr,
        std::shared_ptr<InputValidator> validator = nullptr);

private:
    friend class DataSwitch;
    KeyboardManager();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_CAPS_INTERFACE_KEYBOARD_MANAGER_H
