#ifndef AUBO_SCOPE_USER_INTERFACE_API_H
#define AUBO_SCOPE_USER_INTERFACE_API_H

#include <aubo_caps/domain/user_interface/user_interaction.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(UserInterfaceApi);

/**
 * Provides access to functionality and services available from within AuboScope
 * related to user interface and end user interaction.
 */
class ARCS_ABI_EXPORT UserInterfaceApi
{
public:
    UserInterfaceApi(UserInterfaceApi &f);
    UserInterfaceApi(UserInterfaceApi &&f);
    virtual ~UserInterfaceApi();

    /**
     * @return An interface which provides functionality for requesting input
     * and actions from end users.
     */
    UserInteractionPtr getUserInteraction();

private:
    friend class DataSwitch;
    UserInterfaceApi();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_USER_INTERFACE_API_H
