#ifndef AUBO_SCOPE_VALUE_FACTORY_H
#define AUBO_SCOPE_VALUE_FACTORY_H

#include <aubo_caps/class_forward.h>
#include <aubo_caps/domain/value/expression/expression.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(ValueFactory);

/**
 * <h1>Summary</h1>
 * This interface provides a mean to create immutable value objects using
 * factories. The {@link SimpleValueFactory} helps creating simple value
 * objects. The {@link ExpressionBuilder} helps building valid expressions. The
 * {@link BlendFactory} helps creating blend objects. The {@link
 * JointPositionFactory} helps creating joint positions objects. The {@link
 * PoseFactory} helps creating Pose objects.
 */
class ARCS_ABI_EXPORT ValueFactory
{
public:
    ValueFactory(ValueFactory &f);
    ValueFactory(ValueFactory &&f);
    virtual ~ValueFactory();

    /**
     * This method instantiates a new {@link ExpressionBuilder} to create a
     * single valid expression.
     *
     * @return the builder to build a single expression.
     */
    ExpressionPtr createExpression();
    ExpressionPtr createExpression(const std::string &str);

private:
    friend class DataSwitch;
    ValueFactory();
    void *d_{ nullptr };
};
} // namespace aubo_scope
} // namespace arcs

#endif
