#ifndef AUBO_SCOPE_FEATURE_VARIABLE_H
#define AUBO_SCOPE_FEATURE_VARIABLE_H

#include <aubo_caps/domain/variable/persisted_variable.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(FeatureVariable);

/**
 * A Feature marked as a Variable in the installation will exist even when a
 * robot is turned off and on.
 */
class ARCS_ABI_EXPORT FeatureVariable : public PersistedVariable
{
public:
    FeatureVariable(FeatureVariable &f);
    FeatureVariable(FeatureVariable &&f);
    virtual ~FeatureVariable();

private:
    friend class DataSwitch;
    FeatureVariable();
    void *d_{ nullptr };
};

struct FeatureVariableFilter
{
    bool operator()(VariablePtr var)
    {
        return std::dynamic_pointer_cast<FeatureVariable>(var) != nullptr &&
               var->getType() == Variable::FEATURE;
    }
};

} // namespace aubo_scope
} // namespace arcs
#endif // AUBO_SCOPE_FEATURE_VARIABLE_H
