#ifndef AUBO_SCOPE_GLOBAL_VARIABLE_H
#define AUBO_SCOPE_GLOBAL_VARIABLE_H

#include <aubo_caps/domain/variable/variable.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(GlobalVariable);

/**
 * Global variables are available everywhere in a program.
 */
class ARCS_ABI_EXPORT GlobalVariable : public Variable
{
public:
    GlobalVariable(GlobalVariable &f);
    GlobalVariable(GlobalVariable &&f);
    virtual ~GlobalVariable();

protected:
    GlobalVariable();

private:
    friend class DataSwitch;
    void *d_{ nullptr };
};

struct GlobalVariableFilter
{
    bool operator()(VariablePtr var)
    {
        return std::dynamic_pointer_cast<GlobalVariable>(var) != nullptr &&
               var->getType() == Variable::GLOBAL;
    }
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_GLOBAL_VARIABLE_H
