#ifndef AUBO_SCOPE_VARIABLE_H
#define AUBO_SCOPE_VARIABLE_H

#include <string>
#include <aubo_caps/class_forward.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(Variable);

class ARCS_ABI_EXPORT Variable
{
public:
    Variable(Variable &f);
    Variable(Variable &&f);
    virtual ~Variable();

    /**
     * The variable type used to determine which type of variable this instance
     * is.
     */
    enum Type : int
    {

        /**
         * <p>
         * GLOBAL means that the variable is available everywhere in a program.
         * </p>
         *
         * This variable instance can be cast to {@link GlobalVariable}.
         */
        GLOBAL,

        /**
         * <p>
         * VALUE_PERSISTED means that the variable is stored with the
         * installation. These variables are defined in the installation and
         * will retain their values even when a robot is turned off and on.
         * </p>
         *
         * This variable instance can be cast to {@link ValuePersistedVariable}.
         */
        VALUE_PERSISTED,

        /**
         * <p>
         * FEATURE means that a Feature is marked as a variable. The variable is
         * defined in the installation and will exist even when a robot is
         * turned off and on.
         * </p>
         *
         * This variable instance can be cast to {@link FeatureVariable}.
         */
        FEATURE
    };

    /**
     * @return the type of variable.
     */
    Type getType();

    /**
     * Note: The variable can be renamed at any time.
     *
     * @return the display name of the variable.
     */
    std::string getDisplayName();

    /**
     * @return true if object references the same internal Variable.
     */
    bool equals(VariablePtr object);

    /**
     * @return hashCode for this object.
     */
    size_t hashCode();

    /**
     * @return a string representation of the variable.
     */
    std::string toString();

protected:
    Variable();

private:
    friend class DataSwitch;
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs
#endif // AUBO_SCOPE_VARIABLE_H
