#ifndef AUBO_SCOPE_WAYPOINT_H
#define AUBO_SCOPE_WAYPOINT_H

#include <vector>
#include <string>
#include <aubo_caps/class_forward.h>

namespace arcs {
namespace aubo_scope {
ARCS_CLASS_FORWARD(Waypoint);

/**
 * This interface composes parameters that define a position of the robot.
 */
class ARCS_ABI_EXPORT Waypoint
{
public:
    Waypoint(Waypoint &f);
    Waypoint(Waypoint &&f);
    ~Waypoint();

    std::string getDisplayName();

    /**
     * @return the pose for the position of the robot (including the TCP offset)
     */
    std::vector<double> getPose();

    /**
     * @return the joint positions corresponding to the pose of the robot (when
     * taking the TCP offset into account)
     */
    std::vector<double> getJointPositions();

    /**
     * @return the pose for the TCP offset (used when defining the robot
     * position)
     */
    std::vector<double> getTcpOffset();

    bool isDefined();

    size_t hashCode();

private:
    friend class DataSwitch;
    Waypoint();
    void *d_{ nullptr };
};

} // namespace aubo_scope
} // namespace arcs

#endif // AUBO_SCOPE_WAYPOINT_H
