function(generate_extension_manifest NAME)
    cmake_parse_arguments(${NAME}
      ""
      "DISPNAME;DESCRIPTION;VERSION;PUBLISHER;EMAIL;LICENSE;ICON;DESTINATION"
      ""
      ${ARGN}
    )
    set(GENERATED_MANIFEST ${PLUGIN_OUTPUT_PATH}/${PROJECT_NAME}/package.json)
    set(EXTENSION_NAME ${NAME})
    if(${NAME}_DISPNAME)
      set(EXTENSION_DISPLAY_NAME ${${NAME}_DISPNAME})
    else()
      set(EXTENSION_DISPLAY_NAME ${NAME})
    endif()
    if(${NAME}_DESTINATION)
      set(EXTENSION_DESTINATION ${${NAME}_DESTINATION})
    else()
      set(EXTENSION_DESTINATION .)
    endif()
    if(${NAME}_DESCRIPTION)
      set(EXTENSION_DESCRIPTION ${${NAME}_DESCRIPTION})
    else()
      set(EXTENSION_DESCRIPTION ${NAME})
    endif()
    if(${NAME}_VERSION)
      set(EXTENSION_VERSION ${${NAME}_VERSION})
    else()
      set(EXTENSION_VERSION "1.0.0")
    endif()
    if(${NAME}_PUBLISHER)
      set(EXTENSION_PUBLISHER ${${NAME}_PUBLISHER})
    else()
      set(EXTENSION_PUBLISHER "Unkown")
    endif()
    if(${NAME}_EMAIL)
      set(EXTENSION_EMAIL ${${NAME}_EMAIL})
    else()
      set(EXTENSION_EMAIL "")
    endif()
    if(${NAME}_LICENSE)
      set(EXTENSION_LICENSE ${${NAME}_LICENSE})
    else()
      set(EXTENSION_LICENSE "")
    endif()
    if(${NAME}_ICON)
      set(EXTENSION_ICON ${${NAME}_ICON})
    else()
      set(EXTENSION_ICON "")
    endif()

    # https://stackoverflow.com/questions/12802377/in-cmake-how-can-i-find-the-directory-of-an-included-file
    configure_file(${CMAKE_CURRENT_FUNCTION_LIST_DIR}/package.json.in ${GENERATED_MANIFEST})
    install(FILES ${GENERATED_MANIFEST} DESTINATION ${EXTENSION_DESTINATION})
endfunction()

macro(installBundleDepends)
    cmake_parse_arguments(_ins "" "TARGET;DESTINATION" "" "" ${ARGN})
    if(NOT _ins_TARGET)
      message(SEND_ERROR "TARGET must not be empty")
    endif()
    if(_ins_DESTINATION)
      install(CODE "set(dest \"${_ins_DESTINATION}\")" COMPONENT runtime)
    else()
      install(CODE "set(dest \"lib\")" COMPONENT runtime)
    endif()

    install(CODE "set(tgt \"${_ins_TARGET}\")" COMPONENT runtime)
    install(CODE "set(tgt \"${_ins_TARGET}\")" COMPONENT runtime)

    install(CODE [[
        # https://github.com/probonopd/linuxdeployqt/blob/master/tools/linuxdeployqt/excludelist.h
        set(generatedExcludelist
            libCppMicroServices.so.4.0.0
            libgthread-2.0.so.0
            libicudata.so.56
            libicui18n.so.56
            libicuuc.so.56
            libpcre.so.3
            libQt5Core.so.5
            libQt5Gui.so.5
            libQt5Widgets.so.5
            libX11-xcb.so.1
            libXau.so.6
            libxcb-glx.so.0
            libxcb-present.so.0
            libxcb-sync.so.1
            libXdamage.so.1
            libXdmcp.so.6
            libXext.so.6
            libXfixes.so.3
            libxshmfence.so.1
            libXxf86vm.so.1
            ld-linux.so.2
            ld-linux-x86-64.so.2
            libanl.so.1
            libasound.so.2
            libBrokenLocale.so.1
            libcidn.so.1
            libcom_err.so.2
            libc.so.6
            libdl.so.2
            libdrm.so.2
            libEGL.so.1
            libexpat.so.1
            libfontconfig.so.1
            libfreetype.so.6
            libfribidi.so.0
            libgbm.so.1
            libgcc_s.so.1
            libgdk_pixbuf-2.0.so.0
            libgio-2.0.so.0
            libglapi.so.0
            libGLdispatch.so.0
            libglib-2.0.so.0
            libGL.so.1
            libGLX.so.0
            libgobject-2.0.so.0
            libgpg-error.so.0
            libharfbuzz.so.0
            libICE.so.6
            libjack.so.0
            libm.so.6
            libmvec.so.1
            libnss_compat.so.2
            libnss_db.so.2
            libnss_dns.so.2
            libnss_files.so.2
            libnss_hesiod.so.2
            libnss_nisplus.so.2
            libnss_nis.so.2
            libp11-kit.so.0
            libpango-1.0.so.0
            libpangocairo-1.0.so.0
            libpangoft2-1.0.so.0
            libpthread.so.0
            libresolv.so.2
            librt.so.1
            libSM.so.6
            libstdc++.so.6
            libthai.so.0
            libthread_db.so.1
            libusb-1.0.so.0
            libutil.so.1
            libuuid.so.1
            libX11.so.6
            libxcb-dri2.so.0
            libxcb-dri3.so.0
            libxcb.so.1
            libz.so.1
            )

        file(GET_RUNTIME_DEPENDENCIES
            MODULES ${tgt}
            RESOLVED_DEPENDENCIES_VAR _r_deps
            UNRESOLVED_DEPENDENCIES_VAR _u_deps
            CONFLICTING_DEPENDENCIES_PREFIX CONFLICTING_DEPENDENCIES
            #DIRECTORIES ${MY_DEPENDENCY_PATHS}
        )
      foreach(_file ${_r_deps})
        get_filename_component(_file_name ${_file} NAME)
        list (FIND generatedExcludelist ${_file_name} _index)
        if (${_index} GREATER -1)
          message(STATUS "${_file_name} in generatedExcludelist")
        else()
          file(INSTALL
            DESTINATION "${CMAKE_INSTALL_PREFIX}/${dest}"
            TYPE SHARED_LIBRARY
            FOLLOW_SYMLINK_CHAIN
            FILES "${_file}"
          )
        endif()
      endforeach()
      message(STATUS "CONFLICTING_DEPENDENCIES ${CONFLICTING_DEPENDENCIES_FILENAMES}")
      foreach(_file ${CONFLICTING_DEPENDENCIES_FILENAMES})
        message(STATUS "conflict ${_file}")
        foreach(p ${CONFLICTING_DEPENDENCIES_${_file}})
          message(STATUS "canditate ${p}")
          string(SUBSTRING ${p} 0 9 p_start)
          message("p_start ${p_start}")
          if (NOT "x${p_start}" STREQUAL "x/usr/lib/")
            file(INSTALL
              DESTINATION "${CMAKE_INSTALL_PREFIX}/${dest}"
              TYPE SHARED_LIBRARY
              FOLLOW_SYMLINK_CHAIN
              FILES "${p}"
            )
          endif()
        endforeach()
      endforeach()

      list(LENGTH _u_deps _u_length)
      foreach(_file ${_u_deps})
        message(STATUS "unresolved ${_file}")
      endforeach()
      if("${_u_length}" GREATER 0)
        message(WARNING "Unresolved dependencies detected!")
      endif()
    ]] COMPONENT runtime)
endmacro()

