include(CMakeFindDependencyMacro)
set(ENV{CPM_SOURCE_CACHE} $ENV{HOME}/.cache/CPM)
include(${CMAKE_CURRENT_LIST_DIR}/CPM_0.34.3.cmake)

# 如果想要获取Config阶段的变量，可以使用这个
# set(my-config-var )

# 如果你的项目需要依赖其他的库，可以使用下面语句，用法与find_package相同
# find_dependency(MYDEP REQUIRED)
include("${CMAKE_CURRENT_LIST_DIR}/aubo_extension.cmake")

# Any extra setup
CPMAddPackage(cppmicroservices
    NAME cppmicroservices
    URL "https://download.aubo-robotics.cn/sdk/CppMicroServices-4.0.0-${CMAKE_SYSTEM_NAME}_${CMAKE_SYSTEM_PROCESSOR}+21dbea9.zip"
    VERSION 4.0.0
    DOWNLOAD_ONLY YES
)
# 为交叉编译准备
if(CMAKE_CROSSCOMPILING)
    set(IMPORT_EXECUTABLES "${cppmicroservices_SOURCE_DIR}/host/ImportExecutables.cmake" CACHE FILEPATH "A file containing the CMake target definition for the host build version of usResourceCompiler.")
endif()
find_dependency(CppMicroServices REQUIRED PATHS ${cppmicroservices_SOURCE_DIR}/share/cppmicroservices4/cmake)

# Add the targets file
include("${CMAKE_CURRENT_LIST_DIR}/aubo_studio_sdkTargets.cmake")
