# **`MyFirstAuboCap`--开发`Contribution`类**

在本小节，我们将为`hello`程序节点开发`Contribution`类。

**`Contribution`类 (ProgramNodeContribuyion) 的简要说明:**

> `Contribution`类的目的：为节点提供需要的特殊API,以及生成`Script`脚本用以执行程序节点的功能，该代码基于`dataModel`中存储的配置信息。
>
> 对于程序中程序节点的每个实例，都有一个`ProgramNodeContribution`实例。

------

该类中对于各种重载函数的详细描述，可在文章[程序节点的集成原理](Principle_of_aubocaps_integration_in_aubo_scope.md)中查看。

**`dataModel`的简要说明：**

> 程序节点的配置存储在`dataModel`中。每个条目都有一个称为*key*的唯一标识符，并且`Contribution`可以通过`key-identifier`设置和检索`dataModel`的值。`dataModel`的输入通常来自用户，在`View`中进行了一些修改。因此，当发生更改时，`Contribution`通常会实现许多*公共有函数，这些函数由`View`调用。

**脚本生成的简要说明：**

> - 当用户在程序中按`play`时，需要所有当前的程序节点和安装节点来生成`Script`。
>
> - 实际上，机器人实际上实时执行的是此`Script`。因此，任何程序节点的目的都是生成`Script`，该脚本将在运行时执行该节点的操作。
>
> - 配置了`dataModel`后，使用程序节点设置，`ProgramNodeContribution`应该能够生成执行所需的`Script`。
>
> - 如果节点未完全配置，即无法使用`dataModel`中存在的设置执行，则`isDefined()`函数应返回false。如果节点可以使用`dataModel`中的设置执行，则该节点必须返回true。
>
> - 播放或保存程序时将调用方法`generateScript()`。作为参数，该方法提供了一个`ScriptWriter`对象，需要使用该节点生成的脚本进行配置。例如，可以使用以下命令完成此操作：
>
>   ```C++
>   scriptWriter.appendLine(functional line of Script);
>   ```

**用户界面控制：**

> 当用户进入程序节点时，将调用`openView()`。当用户离开时，将调用`closeView()`。这两种方法可用于控制用户界面`View`中显示的值。记住：只有一个`View`，但是可能有多个`Contribution`。

------

**hello节点`Contribution`类的示例代码如下：**

1. `hello_program_node_contribution.h`

   ```c++
   #ifndef HELLO_PROGRAM_NODE_CONTRIBUTION_H
   #define HELLO_PROGRAM_NODE_CONTRIBUTION_H
   
   #include <aubo_caps/contribution/program/program_node_contribution.h>
   #include <aubo_caps/contribution/program/program_api_provider.h>
   #include <aubo_caps/domain/data/data_model.h>
   
   using namespace arcs::aubo_scope;
   
   ARCS_CLASS_FORWARD(helloProgramNodeView);
   
   class helloProgramNodeContribution : public ProgramNodeContribution
   {
   public:
       helloProgramNodeContribution(ProgramApiProviderPtr api_provider,
                                    helloProgramNodeViewPtr view, DataModelPtr model);
       ~helloProgramNodeContribution();
   
       void openView() override;
       void closeView() override;
       std::string getTitle() override;
       bool isDefined() override;
       void generateScript(ScriptWriterPtr script_writer) override;
   
   private:
       ProgramApiProviderPtr api_provider_ {nullptr};
       helloProgramNodeViewPtr view_ {nullptr};
       DataModelPtr model_ {nullptr};
   };
   
   #endif // HELLO_PROGRAM_NODE_CONTRIBUTION_H
   ```

2.  `helllo_program_node_contribution.cpp`

   ```c++
   #include "hello_program_node_contribution.h"
   
   #include <aubo_caps/domain/script/script_writer.h>
   
   helloProgramNodeContribution::helloProgramNodeContribution(
           ProgramApiProviderPtr api_provider, helloProgramNodeViewPtr view,
           DataModelPtr model)
       : api_provider_(api_provider), view_(view), model_(model)
   {
   }
   
   helloProgramNodeContribution::~helloProgramNodeContribution()
   {
   }
   
   void helloProgramNodeContribution::openView()
   {
   }
   
   void helloProgramNodeContribution::closeView()
   {
   }
   
   std::string helloProgramNodeContribution::getTitle()
   {
       return "hello";
   }
   
   bool helloProgramNodeContribution::isDefined()
   {
       return true;
   }
   
   void helloProgramNodeContribution::generateScript(ScriptWriterPtr script_writer)
   {
   }
   ```

   

