# **`MyFirstAuboCap`--开发`View`类**

在本小结，我们将为`hello`程序节点开发`View`类。

**`View`类 (ProgramNodeView) 的简要说明:**

> - `View`类的目的：为节点提供用户交互界面。
>
> - `View`类中只有一种重载的函数`buildUi()`:  其作用是将节点的用户界面镶嵌到aubo_scope的用户界面上，并填充到合适的大小。
>
> - 对于每种类型节点，只有一个`View`类的实例，而对于这种类型的节点可以有多个节点实例。在这种情况下，会有多个`Contribution`实例，其中包含各个程序节点的逻辑和设置。因此，在`buildUI()`中还提供了一个`ContributionProvider`对象作为参数。
>
> - `ContributionProvider`允许`View`通过调用`provider.get()`来获得程序树中被选中的活动程序节点，同时，在`ContributionProvider`中通过以下代码，提供了对`contribution`类的访问。
>
>   ```c++
>   template <class T>
>   using ContributionProviderPtr = std::shared_ptr<ContributionProvider<T>>;
>   ```

------

**hello节点`view`类的示例代码如下：**

1. `hello_program_node_view.h`

   ```c++
   #ifndef HELLO_PROGRAM_NODE_VIEW_H
   #define HELLO_PROGRAM_NODE_VIEW_H
   
   #include <QWidget>
   #include <aubo_caps/contribution/program/program_node_view.h>
   #include <aubo_caps/contribution/view_api_provider.h>
   
   namespace Ui {
   class helloProgramNodeView;
   }
   
   using namespace arcs::aubo_scope;
   
   class helloProgramNodeView : public QWidget, public ProgramNodeView
   {
       Q_OBJECT
   
   public:
       helloProgramNodeView(ViewApiProviderPtr api_provider, QWidget *parent = 0);
       ~helloProgramNodeView();
       void buildUi(
               WidgetHandle parent,
               ContributionProviderPtr<ProgramNodeContribution> contribution) override;
   
   private:
       Ui::helloProgramNodeView *ui;
       ViewApiProviderPtr view_api_;
   };
   
   #endif // HELLO_PROGRAM_NODE_VIEW_H
   ```

2. `hello_program_node_view.cpp`

   ```c++
   #include "hello_program_node_view.h"
   #include "./ui_hello_program_node_view.h"
   
   helloProgramNodeView::helloProgramNodeView(ViewApiProviderPtr api_provider,
                                              QWidget *parent)
       : QWidget(parent), ui(new Ui::helloProgramNodeView), view_api_(api_provider)
   {
   }
   
   helloProgramNodeView::~helloProgramNodeView()
   {
       delete ui;
   }
   
   void helloProgramNodeView::buildUi(
           WidgetHandle parent,
           ContributionProviderPtr<ProgramNodeContribution> contribution)
   {
       setParent((QWidget *)parent);
       ui->setupUi(this);
   }
   ```

------

**hello节点的用户界面如下图所示：**

![](pics/sample_myfirstcap.png)