# **`aubo_caps_template`插件开发模板的使用**

## **安装**

> [下载开发模板](http://git.aubo-robotics.cn:8001/aubo_plus/template.git)
>
> ```
> git clone http://git.aubo-robotics.cn:8001/aubo_plus/template.git
> cd template
> chmod +x ./INSTALL.sh
> ./INSTALL.sh
> ```

## **使用**

**新建插件工程**：

1. 打开` Qt Creator `点击文件-->新建文件或项目。

   > <img src="pics/img_template_01.png" style="float:left;" />

2. 在弹出的向导中选择`Library`->`aubo_caps`。

   > <img src="pics/img_template_02.png" style="float:left;zoom:90%" />

3. 选择工程保存路径，点击下一步`next`。

   > <img src="pics/img_template_03.png" style="float:left;" />

4. 输入工程详细信息: 厂商名字，`Email`，工程描述，官网链接，点击下一步`Next`。

   > <img src="pics/img_template_04.png" style="float:left;" />

5. 选择编译系统，目前仅支持`CMake`，点击下一步`Next`。

   > <img src="pics/img_template_05.png" style="float:left;" />

6. 选择编译工具链，需要选择 `Qt 5.12.9 + gcc7.5`工具链，单击下一步`Next`。

   > <img src="pics/img_template_06.png" style="float:left;" />

7. 最后一步会展示添加到工程的文件，单击完成`Finish`。

   > <img src="pics/img_template_07.png" style="float:left;" />

**编译工程：**

1. 右键工程名字，选择**`执行Cmake`**。

   > <img src="pics/img_template_08.png" style="float:left;" />

2. `CMake` 完成之后可以对工程进行编译了，右键工程名字，选择 `Build`。

   > <img src="pics/img_template_09.png" style="float:left;" />

**向工程添加新的节点：**

1. 点击菜单栏的文件->新建文件或项目，在弹窗中选择`文件和类`中的`aubo_caps`->`Aubo installation`/`program Node`。选择`Choose`。

   > <img src="pics/img_template_10.png" style="float:left;zoom:91%;" />

2. 输入节点名字（英文），选择节点保存路径，点击下一步`Next`。

   > <img src="pics/img_template_11.png" style="float:left;" />

3. 选择节点类型`Program`/`Installation`,点击下一步`Next`。

   > <img src="pics/img_template_12.png" style="float:left;" />

4. 最后一页将展示将要添加到工程的文件列表，点击完成`Finish`。

   > <img src="pics/img_template_13.png" style="float:left;" />

5. 由于` Qt Creator` 无法将源文件直接添加到工程中，需要手动加在`CMakeLists.txt` 中添加节点源码。

   > ```c++
   > ...
   > file(GLOB program_src "src/*")
   > 
   > add_library(myplugin SHARED ${_srcs} ${program_src} src/activator.cpp)
   > ...
   > ```
   >
   > <img src="pics/img_template_14.png" style="float: left; zoom: 90%;" />

6. 为了使加入的节点包含到插件中，还需要在 `activator.cpp` 中添加响应语句。

   > <img src="pics/img_template_15.png" style="float: left; zoom: 83%;" />

​       重新执行 `CMake` -> `Build` 步骤。

**打包：**

1. 通过生成的 `deploy.sh` 脚本打包。

   > ```c++
   > cd <工程根目录>
   > chmod +x ./deploy.sh
   > ./deploy.sh
   > 
   > # 插件将生成在 build 目录
   > ```
   >
   > <img src="pics/img_template_16.png" style="float: left; zoom: 90%;" />

2. 加载插件到示教器

   将打包生成的插件压缩包拷贝到 arcs 工作空间(`/root/arcs_ws`)。

   > <img src="pics/img_template_17.png" style="float: left; zoom: 113%;" />

   启动 `aubo_scope` 示教器软件，进入主页，点击 `Settings` ->` System` -> ` AuboCaps`，点击页面下方的 `+`。

   > <img src="pics/img_template_18.png" style="float: left; zoom: 67%;" />

   在弹窗中选择要加载的插件。

   >  <img src="pics/img_template_19.png" style="float:left;" />

   加载完成之后，在 `AuboCaps` 界面使能加载的插件(点击Enable)。

   > <img src="pics/img_template_20.png" style="float: left; zoom: 80%;" />

   重启软件，就可以在  `Program` -> `AuboCaps`窗口看到加载的插件。

   > <img src="pics/img_template_21.png" style="zoom: 76%; float: left;" />