# **`arcs`软件架构概述**

`arcs`控制器具有两个主要的软件进程，这对于`aubo_caps`的操作至关重要。了解他们之间的交互会很好的简化`aubo_caps`的开发。

**aubo_scope：**

> - `aubo_scope`[^示教器程序]，它为用户和机器人之间的交互提供了一套便捷的图形编程界面。
> - 并且`aubo_scope`中捆绑了`aubo_caps`[^插件系统]，用以扩展`aubo_scope`的功能。
>

**aubo_control：**

> - `aubo_control`[^实时控制器]，它是控制器软件的主程序，控制着机器人的运动并执行机器人程序。
> - 本质上，`aubo_control`从`aubo_scope`接收相关的机器人程序并将其转换为机器人各个关节所遵循的命令。

`aubo_scope`的开发主要针对以下两个方面：程序节点[^ProgramNode]、安装节点[^InstallationNode]。

`aubo_caps`的开发是对`aubo_scope`的一个扩展，因此`aubo_caps`的开发也主要针对这两个方面。

## **程序节点**

`aubo_scope`中的程序节点主要包括 ***内置节点*** 和 ***插件系统*** 提供的新程序节点。程序节点在程序树中排序，并以此确定了机器人在运行程序时执行的顺序并且每一类程序节点可以创建多个实例。本质上，程序节点作用于应用程序中特定时间发生的命令。

**内置节点**：

> - `aubo_scope`中内置程序节点如图所示：
>
>   <img src="pics/sample_programnodes.png" style="float:left;" />
>

------

> **`Basic`:**  基本程序节点
>
> - `Move`:  用于机器人末端工具中心点在路点之间的移动。
> - `Waypoint`:  用于机器人末端将要到达的位置，必须在`Move`命令下。                                                                                                                                                                                                                                                                                                            
> - `Direction`:  设置机器人朝哪个方向运动，必须在`Move`命令下。
> - `Circle`:  设置机器人相对于圆运动，必须在`Move`命令下。
> - `Until`:  必须在`waypoint`命令或`Direction`命令下。
> - `Assign`:  分配给变量或者表达式。
> - `Comment`:  可对程序进行解释说明。
> - `Popup`:  弹窗，向用户传递状态信息。
> - `Set`:  可设置IO, 变量等参数。
> - `Payload`:  创建有效负载节点。
> - `Wait`:  可设置等待时间或者数字输入信号。
> - `Timer`:  可设置开始或者停止时间
> - `Folder`:  可从文件夹选择一些程序设置
> - `Halt`:  程序急停。
>
> **`Advanced`:**
>
> - `Loop`:  包含的程序会循环执行。
> - `Break`:  跳出循环。
> - `IfBlock`:  仅包含if语句代码块。
> - `If`:  选择判断，根据判断条件选择运行不同的程序分支。
> - `Elself`:  选择判断，根据判断条件选择运行不同的程序分支。
> - `Else`:  选择判断，根据判断条件选择运行不同的程序分支。
> - `Switch`:  选择判断，根据判断条件选择运行不同的程序分支。
> - `Case`:  选择判断，根据判断条件选择运行不同的程序分支。
> - `Default`:  选择判断，根据判断条件选择运行不同的程序分支。
>
> **`Templates`:**
>
> - `Script`:  可用于脚本编辑，可以添加行脚本或者脚本文件。
> - `SubProg`: 子程序。
> - `Thread`:  多线程控制命令，在Thread程序段里必须有一个Loop，在该Loop中可实现与主程序的并行控制。
> - `Call`:  在程序执行时选择要在此时调用的子例程。
> - `Pallet`:  机器人托盘相关参数的配置。

**aubo_caps**:

> 通常包括打开或者关闭抓手、执行视觉系统的拣选顺序、记录系统发送消息。

## **安装节点**

`aubo_scope`中的安装节点主要包括 ***内置节点*** 和 ***插件系统*** 提供的新安装节点。安装节点包含设置和环境配置，没有顺序，并包含该区域的配置选项。安装节点只能有一个实例。

**内置节点**：

> - 包括工具中心点的配置[^TCP]、空的末端执行器的有效负载[^Payload]、安全系统配置[^Safety]、环境坐标系、现场总线设置[^Fieldbus]等。
>
> - `aubo_scope`中内置安装节点如图所示：
>
>   <img src="pics/sample_installationnodes.png" style="float:left;" />
>

------

> **`General`:**  常用配置
>
> - `Home`:  对机器人默认值的配置
> - `I/O Setup`:  对I/O的默认配置
> - `StartUp`:  当机器人上电或者关机的时候自动初始化为默认的程序设置
> - `TCP`：对工具中心点相关参数的配置。
> - `Payload`:  对执行器有效负载相关参数的配置。
> - `Tool I/O`:  工具IO，为机器人使用的特定工具提供电源和控制信号。
> - `Variables`:  创建、配置、删除变量信息。
> - `Features`:  环境坐标系的配置。
>
> **`Safety`:**  安全系统配置
>
> - `I/O`:  安全IO,确保单一故障时不会丧失功能。
> - `Hardware`:  硬件相关配置，例如示教器。
> - `Joint limits`:  关节移动极限值的配置。
> - `Safe Home`:  安全原点。
> - `Three Position`:  启用或者禁用高速测试功能。
> - `Tool Direction`:  可读写`Tool`的方向信息。
> - `Tool Position`:  可读写`Tool`的位置信息。
>
> **`Fieldbus`:**  现场总线配置
>
> - `PROFINET`:  可对机器人的Profinet参数进行配置。

**aubo_caps**:

> - 包括基本配置（IP地址以及外部设备的连接）、已安装硬件或连接的配置（例如末端执行器的安装）、用于电信号的端子。
> - 视觉系统的校准/对齐以及对工件/零件的示教定位也属于安装领域。

所有安装节点的集合，通常对应于机器人所处的物理位置-即机器人环境。

可以有多种安装方式，通常发生在机器人实际运动的时候，因此当机器人位于某个特定的位置时，每个安装节点都可以反映其设置。

安装节点可以选择将程序代码提交到程序的最开始，因此它们也适用于硬件初始化或程序变量的初始化。

## **控制流程**

当用户使用程序节点和安装节点来构建程序时，每个节点都在`DataModel`对象中包含其信息。`DataModel`反映了用户配置的特定节点信息。当用户最终希望通过按`play`按钮执行程序时，将查询安装和程序中已经存在的每个节点，然后转换为`Script`代码。

实质上，机器人最终运行的是用户设置的安装和程序节点所转换而来的脚本代码；节点的主要目的是能够更具用户的配置生成`LuaScript`，***安装节点***  将`LuaScript`添加到程序开头，***程序节点***  将`LuaScript`转换到它们在程序中的相应位置。

**流程概述:**

> 1. 在所有安装节点和程序节点都构建了自己的`Script`之后，`aubo_scope`将把完整的`Script`代码合并到程序定义中。
>2. 将安装节点的`Script`代码放在程序的最开始（用于硬件的初始化或者程序节点的初始化），然后构建程序节点所组成的程序。
> 3. 将完整的`Script`代码通过`Primary Client Interface`发送到`aubo_control`
> 4. `aubo_scope`收到完整的`Script`代码后，开始逐行执行脚本代码。

**具体示例:**

> ```mermaid
> sequenceDiagram
> aubo_control->>aubo_scope: initate service
> aubo_scope->>Daemon form aubo_caps: Run/Stop
> Daemon form aubo_caps->>aubo_scope:Custom to aubo_caps
> aubo_scope->>aubo_contral: Send Script
> aubo_contral->>aubo_scope: Robot State
> ```