# **`aubo_caps API概述`**

`aubo_caps API`为机器人安装的`aubo_caps`提供了一组功能。本文将按照主题概述这些API提供的功能。有关完整的API介绍，请参考下一章[aubo_caps API总览。](aubo_capsAPI_summary.md)

`aubo_caps API`的“核心”就是`Contribution`。`Contribution`是可以添加到`aubo_scope`中的新服务，为用户提供更加丰富的功能。

有2种一般类型的`Contribution`:

1. **安装节点：**

   > - 安装节点是机器人安装域的扩展；
   >
   > - 安装节点之间没有顺序；
   >
   > - 安装节点可以提供用户交互界面并添加功能以配置“环境设置”。

2. **程序节点：**

   > - 程序节点是机器人程序域的扩展；
   > - 程序节点之间在程序树中按顺序排放，并以此决定了机器人在运行程序时被执行的顺序；
   > - 程序节点可以为机器人的程序流程提供新的编程思想，并提供用户交互界面。


`aubo_caps`提供的扩展通用类型（安装节点，程序节点）2个用户界面可以访问`aubo_caps API`中的许多功能。而提供给这些节点的API通常称为域API,这类API提供对机器人的域详细信息和逻辑的访问。

由于程序节点和安装节点是在机器人程序的上下文中获得的，该上下文具有特殊的API功能。这些功能仅在`Installation`域或`Program`域中才有意义，这两类API分别为安装API、程序API。

## **域API**

提供给一般节点类型的通用API称为域API。但是，并非在任何给定时间，此API中的所有功能都对所有节点类型有意义。因此，将域API以合理的API子类型提供给使用`aubo_caps`的节点。

有3种基于域的API:

1. **应用程序API:**

   > 提供对与机器人或应用程序特定功能相关的API的访问。即机器人的I/O，程序变量或坐标系（特征）。

2. **系统API:**

   > 提供对包含有关机器人的系统信息的API的访问。即序列号，软件版本或系统语言。

3. **用户界面API:**

   > 提供与UI中与用户进行交互时相关的API的访问。即创建键盘，或要求用户定义位置。

## **安装API**

1. 提供仅在`Program`域中才有意义的功能;
2. `安装API`是对`应用程序API`的扩展，包括了可用于安装节点的特殊功能，例如创建Tcp、创建Feature等。

## **程序API**

1. 提供仅在`Installation`域中才有意义的功能;
2. `程序API`是对`系统API`和`用户界面API`的扩展，包括了可用于程序节点的功能，例如构建程序节点模板。

在特定于节点类型的“Provider“对象中提供了对`安装API`和`程序API`的访问。

例如：

> - 安装节点将收到`InstallationAPIProvider`对象，该对象提供对与安装节点相关的API的访问。
>
>
> - `InstallationAPIProvider`通过`InstallationNodeService`类中的`createInstallationNode()`函数传递给安装节点。从那里，在构建时应将Provider传递到新创建的安装节点中。

## **API概述**

以下是aubo_caps API提供功能的 简单概述：

![](pics/sample_API_overview.png)